# Grinfi LinkedIn Lead Extractor

## Overview

This is a Chrome Extension (Manifest V3) that integrates with LinkedIn and the Grinfi lead generation platform. It allows users to extract profile data from LinkedIn pages and add those profiles as leads to their Grinfi lists via the Grinfi API (`https://leadgen.grinfi.io`).

The extension consists of:
- A **content script** that runs on LinkedIn pages to scrape profile data (name, headline, etc.)
- A **popup UI** that lets users configure their API key, view extracted profile info, and add/move leads to Grinfi lists
- A **background service worker** that proxies API calls to the Grinfi backend to avoid CORS issues

## User Preferences

Preferred communication style: Simple, everyday language.

## System Architecture

### Extension Architecture (Chrome Manifest V3)

The project follows standard Chrome Extension architecture with three main components:

1. **`manifest.json`** — Extension configuration using Manifest V3. Declares permissions for `storage`, `activeTab`, `scripting`, and `tabs`. Sets up host permissions for LinkedIn and the Grinfi API domain. Content scripts are injected on all `linkedin.com` pages at `document_end`.

2. **`content.js`** — Content script injected into LinkedIn pages. Scrapes profile data using DOM selectors. Uses multiple fallback selectors to handle LinkedIn's frequently changing class names and page structure. Extracted data includes name (split into first/last), headline, and LinkedIn URL.

3. **`popup.html` / `popup.js`** — The extension popup UI. Handles API key management (saved via `chrome.storage.sync`), connection testing, list fetching, and adding/moving leads. UI state like collapsed sections is persisted via `chrome.storage.local`.

4. **`background.js`** — Service worker that acts as an API proxy. Listens for `makeApiCall` messages from the popup/content scripts and forwards requests to `https://leadgen.grinfi.io`. This pattern solves CORS restrictions that would block direct API calls from content scripts.

### Data Flow

1. User navigates to a LinkedIn profile
2. Content script extracts profile data from the DOM
3. Popup requests extracted data and displays it
4. User selects a Grinfi list and clicks add/move
5. Popup sends message to background script
6. Background script makes API call to Grinfi backend
7. Response flows back through the message channel

### Storage

- **`chrome.storage.sync`** — Stores the Grinfi API key (synced across devices)
- **`chrome.storage.local`** — Stores UI state preferences (like collapsed sections)
- No database is used; all persistent data lives in Chrome storage or on the Grinfi backend

### Key Design Decisions

- **Multiple CSS selector fallbacks**: LinkedIn frequently changes its DOM structure and class names. The content script uses arrays of selectors tried in order, which improves resilience but requires ongoing maintenance.
- **Background script as API proxy**: API calls are routed through the background service worker rather than made directly from content scripts. This avoids CORS issues and keeps API key handling centralized.
- **Manifest V3**: Uses the modern service worker model instead of the deprecated persistent background page, which is required for new Chrome Web Store submissions.

## External Dependencies

### APIs
- **Grinfi Lead Generation API** (`https://leadgen.grinfi.io`) — The core backend service. Used for authentication testing, fetching lists, adding leads, and moving leads between lists. Requires an API key for authentication.

### Platform Dependencies
- **LinkedIn** (`https://www.linkedin.com`) — The extension injects content scripts on LinkedIn pages to extract profile data. No LinkedIn API is used; data is scraped directly from the DOM.
- **Chrome Extensions API** — Uses `chrome.storage`, `chrome.runtime`, `chrome.tabs`, and `chrome.scripting` APIs.

### Third-Party Libraries
- None. The extension uses vanilla JavaScript with no external libraries or build tools. No package.json or build system exists.

### Static Assets
- **`icons/`** — Extension icons in 16px, 48px, and 128px sizes
- **`assets/`** — Web-accessible resources available to content scripts on LinkedIn pages