// Background script for Chrome extension
chrome.runtime.onInstalled.addListener(() => {
    console.log('Grinfi LinkedIn Extension installed');
});

// Handle messages from content scripts or popup
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    if (request.action === 'makeApiCall') {
        // Proxy API calls if needed (for CORS issues)
        makeGrinfiApiCall(request.endpoint, request.options)
            .then(response => sendResponse({success: true, data: response}))
            .catch(error => sendResponse({success: false, error: error.message}));
        return true; // Keep message channel open
    }
});

async function makeGrinfiApiCall(endpoint, options = {}) {
    const response = await fetch(`https://leadgen.grinfi.io${endpoint}`, options);
    
    if (!response.ok) {
        const errorText = await response.text();
        throw new Error(`API call failed: ${response.status} ${errorText}`);
    }
    
    return await response.json();
}