import requests
import time
import streamlit as st

def run():
    def run_airtable_update(BASE_ID1, TABLE1_NAME, source_column_name, target_column_name):
        API_KEY = "patzM6KSS5OfvR8WL.7f89cde0aba244f9157468e8e4452e6bb9a8bce43f2bf4a8c5f3a25f73b45ca4"
        BASE_ID2 = "appSHWXwuFWOLDlPT"
        TABLE2_NAME = "ukrainian"

        HEADERS = {
            "Authorization": f"Bearer {API_KEY}"
        }

        def fetch_table(base_id, table_name):
            records = []
            offset = None
            while True:
                url = f"https://api.airtable.com/v0/{base_id}/{table_name}?pageSize=100"
                if offset:
                    url += f"&offset={offset}"
                response = requests.get(url, headers=HEADERS).json()
                records.extend(response['records'])
                offset = response.get('offset')
                if not offset:
                    break
                time.sleep(0.2)
            return records

        def update_record(base_id, table_name, record_id, fields):
            url = f"https://api.airtable.com/v0/{base_id}/{table_name}/{record_id}"
            response = requests.patch(url, headers=HEADERS, json={"fields": fields})
            return response.json()

        table1 = fetch_table(BASE_ID1, TABLE1_NAME)
        table2 = fetch_table(BASE_ID2, TABLE2_NAME)

        for record1 in table1:
            first_name = record1["fields"].get(source_column_name)

            if record1["fields"].get(target_column_name):
                continue

            found = False
            for record2 in table2:
                for key, value in record2["fields"].items():
                    if first_name == value:
                        found = True
                        update_name = record2["fields"].get("Ukrainian_Name")
                        update_record(BASE_ID1, TABLE1_NAME, record1["id"], {target_column_name: update_name})
                        break

                if found:
                    break

            if not found:
                update_record(BASE_ID1, TABLE1_NAME, record1["id"], {target_column_name: None})

            time.sleep(0.2)

    st.title('Airtable Updater')

    BASE_ID1 = st.text_input("Enter Base ID for Update Table:", '')
    TABLE1_NAME = st.text_input("Enter Table Name for Update Table:", '')
    source_column_name = st.text_input("Enter Source Column Name:", '')
    target_column_name = st.text_input("Enter Target Column Name:", '')

    if st.button('Run Update'):
        run_airtable_update(BASE_ID1, TABLE1_NAME, source_column_name, target_column_name)
