import streamlit as st
import requests
import json

def run():
    st.title('Airtable Record Mover')

    API_KEY = 'patzM6KSS5OfvR8WL.7f89cde0aba244f9157468e8e4452e6bb9a8bce43f2bf4a8c5f3a25f73b45ca4'  # Замените на ваш API ключ
    BASE_ID = st.text_input("Введите ID базы данных:")
    TABLE_NAME_1 = st.text_input("Введите название проверяемой таблицы:")
    TABLE_NAME_2 = st.text_input("Введите название таблицы куда убирать лишнее:")
    COLUMN_NAME = st.text_input("Введите название колонки для проверки:")

    HEADERS = {
        'Authorization': f'Bearer {API_KEY}',
        'Content-Type': 'application/json'
    }

    def fetch_all_records(table_name):
        records = []
        url = f'https://api.airtable.com/v0/{BASE_ID}/{table_name}'
        params = {}
        while True:
            response = requests.get(url, headers=HEADERS, params=params)
            data = response.json()
            records.extend(data['records'])
            
            if 'offset' in data:
                params['offset'] = data['offset']
            else:
                break
        return records

    def move_record_to_table(record_id, from_table, to_table):
        get_url = f'https://api.airtable.com/v0/{BASE_ID}/{from_table}/{record_id}'
        delete_url = f'https://api.airtable.com/v0/{BASE_ID}/{from_table}/{record_id}'
        post_url = f'https://api.airtable.com/v0/{BASE_ID}/{to_table}'
        
        record = requests.get(get_url, headers=HEADERS).json()
        requests.delete(delete_url, headers=HEADERS)
        
        new_record = {'fields': record['fields']}
        requests.post(post_url, headers=HEADERS, json=new_record)

    if st.button("Начать"):
        if not all([BASE_ID, TABLE_NAME_1, TABLE_NAME_2, COLUMN_NAME]):
            st.warning("Пожалуйста, заполните все поля.")
        else:
            records = fetch_all_records(TABLE_NAME_1)
            domain_count = {}
            
            for record in records:
                domain = record['fields'].get(COLUMN_NAME, None)
                
                if domain is not None:
                    domain_count[domain] = domain_count.get(domain, 0) + 1
                    
                    if domain_count[domain] > 2:
                        move_record_to_table(record['id'], TABLE_NAME_1, TABLE_NAME_2)

            st.success("Записи успешно перемещены.")

if __name__ == '__main__':
    run()
