import streamlit as st
from airtable import Airtable

def run():
    st.title("Delete Indus App")
    st.write("This app deletes records based on certain conditions.")

    # Поля для ввода данных
    API_KEY = 'patzM6KSS5OfvR8WL.7f89cde0aba244f9157468e8e4452e6bb9a8bce43f2bf4a8c5f3a25f73b45ca4'
    BASE_ID1 = 'appSHWXwuFWOLDlPT'
    TABLE_NAME1 = 'indus'

    BASE_ID2 = st.text_input("Enter the Base ID where records will be deleted:", "")
    TABLE_NAME2 = st.text_input("Enter the Table Name where records will be deleted:", "")
    COLUMN_NAME2 = st.text_input("Enter the Column Name where records will be deleted:", "")

    # Кнопки для запуска и остановки
    if st.button("Run Delete Process"):
        airtable1 = Airtable(BASE_ID1, TABLE_NAME1, api_key=API_KEY)
        airtable2 = Airtable(BASE_ID2, TABLE_NAME2, api_key=API_KEY)

        records1 = airtable1.get_all(fields='name')
        names_to_check = [record['fields'].get('name').lower() for record in records1 if 'name' in record['fields']]

        records2 = airtable2.get_all(fields=COLUMN_NAME2)

        for record in records2:
            target_value = record['fields'].get(COLUMN_NAME2)
            record_id = record['id']

            if target_value:
                target_value_lower = target_value.lower()
                if any(name in target_value_lower for name in names_to_check):
                    airtable2.delete(record_id)
                    st.write(f"Successfully deleted record with ID: {record_id}")

    if st.button("Stop Process"):
        st.write("Process stopped by the user.")
