#!/usr/bin/env python3

import streamlit as st
from airtable import Airtable

def run():
    API_KEY = 'patzM6KSS5OfvR8WL.7f89cde0aba244f9157468e8e4452e6bb9a8bce43f2bf4a8c5f3a25f73b45ca4'
    base_id = st.text_input("Enter the Base ID where records will be deleted:", "")
    table_name = st.text_input("Enter the Table Name where records will be deleted:", "")
    column_name = st.text_input("Enter the Column Name where records will be deleted:", "")
    
    if st.button("Run"):
        try:
            airtable = Airtable(base_id, table_name, api_key=API_KEY)
            records = airtable.get_all()
            unique_values = {}
            for record in records:
                fields = record.get('fields', {})
                value = fields.get(column_name)
                if value is None:
                    st.write(f"Skipping record without field {column_name}: {record['id']}")
                    continue
                if value in unique_values:
                    st.write(f"Deleting duplicate record: {value}")
                    airtable.delete(record['id'])
                else:
                    unique_values[value] = record['id']
        except Exception as e:
            st.write(f"An error occurred: {e}")
